﻿#include  "StdAfx.h"
#include  "Resource.h"
#include  "DllMain.h"
#include  "Render.hpp"
#include  <szVersion.hpp>
#include  <szPath.hpp>

const IID LIBID_EpoMenuLib           = { 0x8625D4F2, 0x07AF, 0x4A03, { 0xB8, 0x0E, 0xDD, 0x28, 0xD3, 0x81, 0xB9, 0xF0 } };
const CLSID CLSID_ContextMenuHandler = { 0x910E5FA7, 0x5A0C, 0x4EB9, { 0xAE, 0xD7, 0x76, 0x28, 0x73, 0x45, 0x7F, 0xFE } };
const CLSID CLSID_DropMenuHandler    = { 0xFCEDA48F, 0x62C7, 0x43C3, { 0x8C, 0x47, 0x90, 0xFB, 0x24, 0xB5, 0xF3, 0x3C } };

CEpoMenuModule _AtlModule;
HINSTANCE hDllInstance;
WORD wVersion;

using namespace szpp;

// DLL エントリ ポイント
extern "C" BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
  switch (dwReason)
  {
  case DLL_PROCESS_ATTACH:
    hDllInstance = hInstance;
    wVersion = static_cast<WORD>(OSVersion::GetVersion());
 
    OnClientStartup(hDllInstance);

    // 言語ファイル
    SetCurrentTextCatalogPath(ChangeFileName(GetClientModuleFileName(), SZL("Languages\\ja.lng")));

    // OS バージョンの設定と Vista 以降の描画関数のロード
    Render::InitializeRender(hInstance);
    break;

  case DLL_PROCESS_DETACH:
    Render::UninitializeRender();
    OnClientShutdown();
    break;
  }
	return _AtlModule.DllMain(dwReason, lpReserved);
}
